#include <xc.h>
#include <pic16f886.h>
#include "port_init.h"
#include "user_define.h"
#include "usart.h"
#include "int.h"

#pragma config BOREN = OFF
#pragma config CPD = OFF 
#pragma config FOSC =INTRC_NOCLKOUT  
#pragma config MCLRE = ON 
#pragma config WDTE = OFF 
#pragma config CP = OFF 
#pragma config LVP = OFF 
#pragma config PWRTE = ON
#pragma config IESO =OFF
#pragma config FCMEN = OFF

#pragma config BOR4V = BOR21V
#pragma config WRT = OFF

unsigned long	hz_no;
unsigned int    level_no;
unsigned char   moji[15];
unsigned char   suji[6];
    
unsigned int	receive_flg;
unsigned char   rx_data[5];
unsigned char   rx_count;
unsigned int    rx_byte;

unsigned int    loop_count;

unsigned char   uart_rx_data;
unsigned char   uart_rx_flg;

/*--------------------RB0 INTERRUPT-------------*/
void	__interrupt() InterReceiver(void)
{
	if(INTF==1){
        loop_count=1;
        if(LEVEL_DATA==0){
            rx_data[rx_byte]=rx_data[rx_byte] | 0x80;
        }
        rx_count++;
        if(rx_count>=8){
            rx_count=0;
            rx_byte++;
            if(rx_byte>=5){
                receive_flg=1;
                rx_count=0;
                rx_byte=0;
                //RA2=1;
            }
            else{
                
            }
        }
        else{
            rx_data[rx_byte]=rx_data[rx_byte] >> 1;
        }
        INTF =0;
	}
    
	if(RCIF==1){
		uart_rx_data=RCREG;
		uart_rx_flg=1;
		RCIF =0;
	}    
    
    
}

/*--------------------HENKAN-----------------------*/
void    henkan_10_6keta(unsigned long data)
{
unsigned char n0,n1,n2,n3,n4,n5;

	n0=(unsigned char)(data%10);data=(data-n0)/10;
	n1=(unsigned char)(data%10);data=(data-n1)/10;
	n2=(unsigned char)(data%10);data=(data-n2)/10;
	n3=(unsigned char)(data%10);data=(data-n3)/10;
    n4=(unsigned char)(data%10);data=(data-n4)/10;
    n5=(unsigned char)(data%10);
    
    suji[0]=n0;
    suji[1]=n1;
    suji[2]=n2;
    suji[3]=n3;
    suji[4]=n4;
    suji[5]=n5;
    
}
void    henkan_10_3keta(unsigned char data)
{
unsigned char n0,n1,n2;

	n0=(unsigned char)(data%10);data=(data-n0)/10;
	n1=(unsigned char)(data%10);data=(data-n1)/10;
	n2=(unsigned char)(data%10);

}
void    henkan_10_4keta(unsigned int data)
{
unsigned char n0,n1,n2,n3;

	n0=(unsigned char)(data%10);data=(data-n0)/10;
	n1=(unsigned char)(data%10);data=(data-n1)/10;
	n2=(unsigned char)(data%10);data=(data-n2)/10;
	n3=(unsigned char)(data%10);
    
    suji[0]=n0;
    suji[1]=n1;
    suji[2]=n2;
    suji[3]=n3;
    
}

/*--------------------CLEAR-----------------------*/
void    rx_data_clear(void)
{
    rx_data[0]=0;
    rx_data[1]=0;
    rx_data[2]=0;
    rx_data[3]=0;
    rx_data[4]=0;
}

/*-------------------JUSIN HENKAN-----------------*/
void    jusin_henkan(void)
{
    
    hz_no=(unsigned long)rx_data[4]*256*256+(unsigned long)rx_data[3]*256+(unsigned long)rx_data[2];
    level_no=(unsigned int)rx_data[1]*256+(unsigned int)rx_data[0];
    
    henkan_10_6keta(hz_no);
    moji[0]=suji[5]+0x30;
    moji[1]=suji[4]+0x30;
    moji[2]=suji[3]+0x30;
    moji[3]=suji[2]+0x30;
    moji[4]=suji[1]+0x30;
    moji[5]=suji[0]+0x30;
    moji[6]=0x2c;        /*,*/
    
    henkan_10_4keta(level_no);
    moji[7]=suji[3]+0x30;
    moji[8]=suji[2]+0x30;
    moji[9]=suji[1]+0x30;
    moji[10]=suji[0]+0x30;
    
    moji[11]=0x0d;      /*CR*/
    moji[12]=0x0a;      /*LF*/
    
}

void    test_henkan(void)
{

    henkan_10_6keta(hz_no);
    moji[0]=suji[5]+0x30;
    moji[1]=suji[4]+0x30;
    moji[2]=suji[3]+0x30;
    moji[3]=suji[2]+0x30;
    moji[4]=suji[1]+0x30;
    moji[5]=suji[0]+0x30;
    moji[6]=0x2c;        /*,*/
    
    henkan_10_4keta(level_no);
    moji[7]=suji[3]+0x30;
    moji[8]=suji[2]+0x30;
    moji[9]=suji[1]+0x30;
    moji[10]=suji[0]+0x30;
    
    moji[11]=0x0d;      /*CR*/
    moji[12]=0x0a;      /*LF*/
    
}
/*-------------------UART TX-----------------------*/
void    data_tx(void)
{
unsigned char   i;

    for(i=0;i<13;i++){
        putch(moji[i]);
        __delay_us(1000);
    }
    
}

/*---------------------MAIN-----------------------*/
void	main(void)
{
	port_init();

	__delay_ms(500);
	
	receive_flg=0;
    rx_count=0;
    rx_byte=0;
    
	init_usart();	
    rb0_int_init();

	hz_no=0;
    level_no=0;
    
    rx_data_clear();
    loop_count=0;

	while(1){

        NOP();
        if(receive_flg==1){
            receive_flg=0;
            //LED=1;
        
            jusin_henkan();
            data_tx();
            
            rx_data_clear();
            if(RC4==1){
                RC4=0;
            }
            else{
                RC4=1;
            }           
        }
        NOP();
        if(loop_count>0){
            loop_count++;
            if(loop_count>=1000){
                rx_count=0;
                rx_byte=0;
                rx_data_clear();
                loop_count=0;
            }
        }
        
        /*TEST*/
       // __delay_ms(800);

        //hz_no++;
        //level_no=500;
        //test_henkan();
        //data_tx();
        
        
        

	}

}